with Reps, Reps.Ops, Reps.IO, Messages, RG_Ops,
Ada.Numerics.Generic_Elementary_Functions,Ada.Characters.Latin_1,Round_Up,  Ada.Text_IO,Ada.Float_Text_IO,  Ada.Command_Line, GetOpt,  Ada.Strings.Unbounded;
--with CoBalls, CoBalls.Ops, CoBalls.IO, Intervals, Intervals.Ops, Intervals.IO;
--use Intervals, Intervals.Ops, Intervals.IO, CoBalls, CoBalls.Ops, CoBalls.IO;
with CoNumbers, CoNumbers.Ops, CoNumbers.IO, Numerics, Numerics.Ops, Numerics.IO;
use CoNumbers, CoNumbers.Ops, CoNumbers.IO, Numerics, Numerics.Ops, Numerics.IO;
use Reps, Reps.Ops, Reps.IO, Messages, Ada.Text_IO,Ada.Float_Text_IO, GetOpt, Ada.Command_Line, Ada.Strings.Unbounded;

--pragma Elaborate_All(Intervals.Ops);
--pragma Elaborate_All(CoBalls.Ops,CoBalls.IO);
pragma Elaborate_All(Numerics.Ops);
pragma Elaborate_All(CoNumbers.Ops,CoNumbers.IO);

pragma Elaborate_All(Reps.Ops);
pragma Elaborate_All (RG_Ops);

procedure Add_Component is

   pragma Suppress(Storage_Check);

   Pdeg:constant Positive:=1000;
   Dho: constant Natural:=1000;
   --   subtype Scalar is Interval;
   --   subtype Comp is CoBall;
   subtype Scalar is Numeric;
   subtype Comp is CoNumber;


   package Current_RG is new RG_Ops(Pdeg,Dho,Scalar,Comp);
   use Current_RG;
   use RG_Tay,RG_Tay_Ops,RG_Tay_IO;
   package Txt_Int_IO is new Ada.Text_IO.Integer_IO(Integer);
   use Txt_Int_IO;
   Test_String : String := "i:o:e:d:z:w:r:";
   Nrm,Eps,Delt: Rep;
   Z,W,Va: Integer;
   Tmp,Tay_P,Tay: Taylor;
   F: File_Type;
   Optchar : character;
   Out_Dir: Unbounded_String;
   In_Dir: Unbounded_String;
   ShowErr: Boolean;
   IsPoly: Boolean:=True;
   GetPoly: constant Boolean:=False;
   Decimal: constant Boolean:=True;
   Brackets: constant Boolean:=False;
begin
   --DEAFULT OPTIONS
   Out_Dir:=To_Unbounded_String("/users/denis/Output/trials/matrix/");
   In_Dir:=To_Unbounded_String("/users/denis/Output/trials/matrix/");
   Rho:=Rep(2.2);
   Eps:=Rep(0.1);
   Delt:=Rep(0.1);
   Z:=3;

   --OPTIONS
   Getopt.Opterr := 1;
   loop
      Va := Getopt.Getopt( Test_String );
      exit when Va = -1;

      optchar :=  Character'Val( Va );
      case optchar is
         when 'i' =>
            In_Dir:=To_Unbounded_String(To_String(Getopt.Optarg));
         when 'o' =>
            Out_Dir:=To_Unbounded_String(To_String(Getopt.Optarg));
         when 'e' =>
            Eps:=Rep'Value(To_String(Getopt.Optarg));
         when 'd' =>
            Delt:=Rep'Value(To_String(Getopt.Optarg));
         when 'z' =>
            Z:=Integer'Value(To_String(Getopt.Optarg));
         when 'w' =>
            W:=Integer'Value(To_String(Getopt.Optarg));
         when 'r' =>
            Rho:=Rep'Value(To_String(Getopt.Optarg));
         when others =>
            New_Line;
            Message("Wrong option in Renorm",Parameter_Error);
      end case;
   end loop;

   declare
      Tay_File_P: String:=To_String(Out_Dir) & "taylor_" & Integer'Image(Z)(2..Integer'Image(Z)'Last) & "_" & Integer'Image(W)(2..Integer'Image(W)'Last);
      Tay_File: String:=To_String(In_Dir) & "taylor";
   begin

      --READING TAYLOR
      New_Line;
      Put("Reading the fixed point ...");
      ShowErr:=False;
      Open(F,In_File,Tay_File);
      Get(Rho,F,Tay,IsPoly,GetPoly,Brackets,Decimal,ShowErr);
      Close(F);
      Put(" done");

      SetZero(Tmp);
      SetComponent(Z,CoOne,Tmp);
      SetComponent(W,Neg(Complecs(Rep(Z),Zero))/Rep(W),Tmp);
      New_Line;
      Put("Vector h=");
      Show(Tmp);
      Nrm:=Norm(Rho,Tmp);
      New_Line;
      Put("||h||_");Txt_Put(Current_Output,Rho);Put("=");Txt_Put(Current_Output,Norm(Rho,Tmp));
      New_Line;
      Tmp:=Complecs(One/Nrm,Zero)*Tmp;
      New_Line;
      Put("Normalized ||h||_");Txt_Put(Current_Output,Rho);Put("=");Txt_Put(Current_Output,Norm(Rho,Tmp));
      Tay_P:=Tay+Complecs(Delt*Eps,Zero)*Tmp;
      Create(F,Out_File,Tay_File_P);
      Put(F,Tay_P,True,False,True,False);
      Close(F);
      return;
   end;
end Add_Component;



























