with Reps.IO;
use Reps.IO;

package body CoBalls.IO is

   procedure Show(C: in CoBall; Cut: in Rep:=Zero) is
   begin
      if Re(C.C)*Re(C.C)+Im(C.C)*Im(C.C)>Cut*Cut or  C.R /= Zero  then
         Put("(");
         Txt_Put(Current_Output,Re(C.C));
         Put(",");
         Txt_Put(Current_Output,Im(C.C));
         Put(")");
         Put(" [");
         Txt_Put(Current_Output,C.R);
         Put(" ]");
      end if;
   end Show;


   procedure Get(F: in File_Type; S: out CoBall;  Brackets: in Boolean:=False; Decimal: in Boolean := True; Radius: in Boolean:=False) is
      R1,R2,R3: Rep;
   begin
      if Radius then
         Txt_Get(F,R1,R2,R3,Decimal);
      else
         Txt_Get(F,R1,R2,Decimal);
         R3:=Zero;
      end if;
      S:=SetBall(Complecs(R1,R2),R3);
   end Get;

   procedure Put(F: in File_Type; S: in CoBall;  Brackets: in Boolean:=False; Decimal: in Boolean := True; Radius: in Boolean:=False) is
   begin
      if Radius then
         Txt_Put(F,Re(S.C),Im(S.C),S.R,Decimal);
      else
         Txt_Put(F,Re(S.C),Im(S.C),Decimal);
      end if;
   end Put;



end CoBalls.IO;
