with Reps.Ops,Messages;
with Round_Up;
use Reps.Ops, Messages;
with Ada.Text_IO,Ada.Float_Text_IO,Reps.IO;
use Ada.Text_IO,Ada.Float_Text_IO,Reps.IO;
pragma Elaborate_All (Reps.Ops);

package body CoBalls.Ops is
   Epsilon: constant Rep := Rep(Two**(-52));
   CoBall_One: constant CoBall:=Complecs(One,Zero);
   CoBall_Zero: constant CoBall:=Complecs(Zero,Zero);


   function Contains(S: CoBall; C: CoBall) return  Boolean is
   begin
      return (InfRe(S)<=InfRe(C) and InfIm(S)<=InfIm(C)) and (SupRe(S)>=SupRe(C) and SupIm(S)>=SupIm(C));
   end Contains;


   function Intersects(S: CoBall; T: CoBall) return Boolean is
      R,I: Rep;
   begin
      R:=Re(S.C)-Re(T.C);--rounds up
      if R<Zero then
         R:=abs(R)+((Re(S.C)-Re(T.C))+(Re(T.C)-Re(S.C)));
      else
         R:=abs(R);
      end if;

      I:=Im(S.C)-Im(T.C);--rounds up
      if I<Zero then
         I:=abs(I)+((Im(S.C)-Im(T.C))+(Im(T.C)-Im(S.C)));
      else
         I:=abs(I);
      end if;

      return  Sqrt(R*R+I*I)<-(-S.R-T.R);  --inf of the sum of radii
   end Intersects;

   function SetBall(R1,R2: Interval) return CoBall is
   begin
      return SetBall(Complecs(Approx(R1),Approx(R2)),Max(Err(R1),Err(R2)));
   end SetBall;


   function RePart(C: CoBall) return Interval is
   begin
      return Scal(-(C.R-Re(C.C)),Re(C.C)+C.R);
   end RePart;


   function ImPart(C: CoBall) return Interval is
   begin
      return Scal(-(C.R-Im(C.C)),Im(C.C)+C.R);
   end ImPart;



   function InfRe(S: CoBall) return Rep is
   begin
      return -(S.R-Re(S.C));
   end InfRe;

   function SupRe(S: CoBall) return Rep is
   begin
      return Re(S.C)+S.R;
   end SupRe;


   function InfIm(S: CoBall) return Rep is
   begin
      return -(S.R-Im(S.C));
   end InfIm;

   function SupIm(S: CoBall) return Rep is
   begin
      return Im(S.C)+S.R;
   end SupIm;

   function Neg(S: CoBall) return CoBall is
   begin
      return (-S.C,S.R) ;
   end Neg;

   --  pragma Inline (Inf,Sup);

   function SupMod(S: CoBall) return Rep is
   begin
      return Sup(AbsVal(S));
   end SupMod;


   function InfMod(S: CoBall) return Rep is
   begin
      return Inf(AbsVal(S));
   end InfMod;


   function AbsBall(S: CoBall) return CoBall is
   begin
      return SetBall(AbsVal(S),Scal(Zero));
   end AbsBall;


   function AbsVal(S: CoBall) return Interval is
      Y,ReS,ImS,Left: Rep;
      X,Val: Interval;
   begin
      if S.C=(Zero,Zero) then
         return Scal(Zero,S.R);
      end if;

      ReS:=abs(Re(S.C));
      ImS:=abs(Im(S.C));

      if ReS>=ImS then
         X:=Sqr(Scal(ImS)/Scal(ReS));
         Y:=ReS;
      else
         X:=Sqr(Scal(ReS)/Scal(ImS));
         Y:=ImS;
      end if;
      Val:=Y*Sqrt(Scal(One)+X)+Scal(-S.R,S.R);
      Left:=Rep'Max(Zero,Inf(Val));
      return Scal(Left,Sup(Val));
   end AbsVal;


   function Cap(R: Radius; S: CoBall) return CoBall is
      -- bound on characteristic_function for closed ball of radius R
      C: CoNum;
      R1,R2,RR,Rp,Ip: Rep;
   begin
      if SupMod(S) <= R then
         return S;
      end if;
      Rp:=Re(S.C);
      Ip:=Im(S.C);
      R1:=Rep'Max(-R,-(S.R-Sqrt(-(-Rp*Rp-Ip*Ip))));--was Rep'Pred
      R2:=Rep'Min(R,SupMod(S));
      C:=Half*((R1+R2)/Sqrt(Rp*Rp+Ip*Ip))*S.C;
      RR:=-Half*( (R1-R2)+( (R1+R2)+(-R1-R2))/Sqrt(-(-Rp*Rp-Ip*Ip))+(R1+R2)*(Sqrt(Rp*Rp+Ip*Ip)/Sqrt(-(-Rp*Rp-Ip*Ip))-Sqrt(-(-Rp*Rp-Ip*Ip))/Sqrt(Rp*Rp+Ip*Ip) ) );--was Rep'Pred
      if  RR<Zero then
         return  SetBall(Complecs(Re(C),Im(C)),Zero); --fine
      else
         return  SetBall(Complecs(Re(C),Im(C)),RR); --fine
      end if;
   end Cap;


   function MaxMod(S1,S2: CoBall) return CoBall is
      Re1: constant Rep:=Re(S1.C);
      Im1: constant Rep:=Im(S1.C);
      Re2: constant Rep:=Re(S2.C);
      Im2: constant Rep:=Im(S2.C);
      U1: constant Rep := Sqrt(Re1*Re1+Im1*Im1)+S1.R;
      L2: constant Rep := -(S2.R-Sqrt(-(-Re2*Re2-Im2*Im2)));--was Rep'Pred
      L1,U2,L,U: Rep;
   begin
      if U1 <= L2 then
         return S2;
      end if;
      L1 :=-(S1.R-Sqrt(-(-Re1*Re1-Im1*Im1)));--was Rep'Pred
      U2 := Sqrt(Re2*Re2+Im2*Im2)+S2.R;
      if U2 <= L1 then
         return S1;
      end if;
      L:=Rep'Max(L1,L2);
      U:=Rep'Max(U1,U2);
      return  SetBall(Complecs(Half*(L+U),Zero), Half*( (U-L)+( (U+L)+(-L-U) ) ) );
   end MaxMod;


   procedure ErrMult(R: in Rep; S: in out CoBall) is
   begin
      S.R := Abs(R)*S.R;
   end ErrMult;


   function "+"(S,T: CoBall) return CoBall is
   begin
      return SetBall(RePart(S)+RePart(T),ImPart(S)+ImPart(T));
   end "+";


   function "-"(S,T: CoBall) return CoBall is
   begin
      return SetBall(RePart(S)-RePart(T),ImPart(S)-ImPart(T));
   end "-";


   function "*"(R: Rep; S: CoBall) return CoBall is
   begin
      return SetBall(R*RePart(S),R*ImPart(S));
   end "*";


   function "/"(S: CoBall; R: Rep) return CoBall is
   begin
      if R=Zero then
         New_Line;
         Message("CoBalls.Ops./",Division_By_Zero);
      end if;
      return SetBall(RePart(S)/R,ImPart(S)/R);
   end "/";


   function "*"(R: Interval; S: CoBall) return CoBall is
   begin
      return SetBall(R*RePart(S),R*ImPart(S));
   end "*";


   function "/"(S: CoBall; R: Interval) return CoBall is
   begin
      if Inf(R)<=Zero and Sup(R)>=Zero  then
         New_Line;
         Message("CoBalls.Ops./",Division_By_Zero);
      end if;
      return SetBall(RePart(S)/R,ImPart(S)/R);
   end "/";


   function Sqr(S: CoBall) return CoBall is
   begin
      return S*S;
   end Sqr;


   function Prod(S,T: CoBall) return CoBall is
      RT1,RT2,RS1,RS2: Interval;
   begin
      RS1:=RePart(S);
      RS2:=ImPart(S);
      RT1:=RePart(T);
      RT2:=ImPart(T);
      return SetBall(RS1*RT1-RS2*RT2, RS1*RT2+RS2*RT1 );
   end Prod;


   function "*"(S,T: CoBall) return CoBall is
      C: CoNum;
      SRT1,RT2,SRS1,RS2: Interval;
      ReS,ReT,ImT,ImS: Rep;
   begin
      if S=CoBall_Zero or T=CoBall_Zero then
         return CoBall_Zero;
      end if;
      ReT:=abs(Re(T.C));
      ReS:=abs(Re(S.C));
      ImT:=abs(Im(T.C));
      ImS:=abs(Im(S.C));
      C :=S.C*T.C;

      if ReT>=ImT then
         SRT1:=Sqr(Scal(ImT)/Scal(ReT));
         RT2:=Scal(ReT);
      else
         SRT1:=Sqr(Scal(ReT)/Scal(ImT));
         RT2:=Scal(ImT);
      end if;
      if ReS>=ImS then
         SRS1:=Sqr(Scal(ImS)/Scal(ReS));
         RS2:=Scal(ReS);
      else
         SRS1:=Sqr(Scal(ReS)/Scal(ImS));
         RS2:=Scal(ImS);
      end if;
      return (C,Sup(S.R*RT2*(Scal(One)+Half*SRT1-Rep(0.125)*Sqr(SRT1)+Rep(0.625)*Sqr(SRT1)*SRT1-Rep(0.0390625)*Sqr(SRT1)*Sqr(SRT1)+Rep(0.02734375)*Sqr(SRT1)*Sqr(SRT1)*SRT1)+
                    T.R*RS2*(Scal(One)+Half*SRS1-Rep(0.125)*Sqr(SRS1)+Rep(0.625)*Sqr(SRS1)*SRS1-Rep(0.0390625)*Sqr(SRS1)*Sqr(SRS1)+Rep(0.02734375)*Sqr(SRS1)*Sqr(SRS1)*SRS1))+
              T.R*S.R+abs(C+(-S.C)*T.C));
   end "*";


   function Long_Prod(S,T: CoBall) return CoBall is
      C: CoNum;
      SRT1,RT2,SRS1,RS2: Interval;
      ReS,ReT,ImT,ImS: Rep;
   begin
      if S=CoBall_Zero or T=CoBall_Zero then
         return CoBall_Zero;
      end if;
      ReT:=abs(Re(T.C));
      ReS:=abs(Re(S.C));
      ImT:=abs(Im(T.C));
      ImS:=abs(Im(S.C));
      C :=S.C*T.C;

      if ReT>=ImT then
         SRT1:=Sqr(Scal(ImT)/Scal(ReT));
         RT2:=Scal(ReT);
      else
         SRT1:=Sqr(Scal(ReT)/Scal(ImT));
         RT2:=Scal(ImT);
      end if;
      if ReS>=ImS then
         SRS1:=Sqr(Scal(ImS)/Scal(ReS));
         RS2:=Scal(ReS);
      else
         SRS1:=Sqr(Scal(ReS)/Scal(ImS));
         RS2:=Scal(ImS);
      end if;
      return (C,Sup(S.R*RT2*Sqrt(Scal(One)+SRT1) + T.R*RS2*Sqrt(Scal(One)+SRS1) ) + T.R*S.R+abs(C+(-S.C)*T.C));
   end Long_Prod;


   procedure RandomBall(Seed: in out Long_Integer; S: out CoBall) is
      Re,Im,R: Rep;
   begin
      NextRandom(Seed);
      Re:=One-Two*Rep(Seed)/Rep(2147483647);
      NextRandom(Seed);
      Im:=One-Two*Rep(Seed)/Rep(2147483647);
      NextRandom(Seed);
      R:=Rep(Seed)/Rep(2147483647)*Rep(1.0E-10);
      S:=SetBall(Complecs(Re,Im),R);
   end RandomBall;


   function Long_Inv(S: CoBall) return CoBall is
      ReS,ImS: Interval;
   begin
      if Contains(S,CoBall_Zero) then
         New_Line;
         Message("CoBalls.Ops.Inv",Division_By_Zero);            -- division by zero
      end if;
      ReS:=abs(RePart(S));
      ImS:=abs(ImPart(S));
      if Inf(ReS)/=Zero and Inf(ImS)/=Zero then --none of the components contains zero
         return SetBall(  Sign(Inf(RePart(S))) / (ReS+ ImS*(ImS/ReS) )   ,  -Sign(Inf(ImPart(S)))   /(ImS+ ReS*(ReS/ImS) )  );
      elsif Inf(ReS)=Zero and Inf(ImS)/=Zero then --real part contains zero
         return SetBall( RePart(S)/(Sqr(ImS)+ Sqr(ReS) ) , -Sign(Inf(ImPart(S)))   /(ImS+ ReS*(ReS/ImS) )  );
      else
         return SetBall(  Sign(Inf(RePart(S))) / (ReS+ ImS*(ImS/ReS) )  ,  -ImPart(S) / (Sqr(ReS)+ Sqr(ImS) )   );
      end if;
   end Long_Inv;


   function Inverse(S: CoBall) return CoBall is
      InvA,ReS,ImS: Interval;
   begin
      if Contains(S,CoBall_Zero) then
         New_Line;
         Message("CoBalls.Ops.Inv",Division_By_Zero);            -- division by zero
      end if;
      ReS:=abs(RePart(S));
      ImS:=abs(ImPart(S));
      InvA:=Inv(ReS*ReS+ImS*ImS);
      return SetBall(RePart(S)*InvA,-ImPart(S)*InvA);
   end  Inverse;


   function Inv(S: CoBall) return CoBall is
      C: CoBall;
      E: constant Rep:=ErrPart(S);
      EB: constant CoBall:=Ball0(E);
   begin
      C:=Inverse(ResetErr(S));
      if E/=Zero then
         C:=C-Sqr(Inverse(S))*EB;
      end if;
      return C;
   end Inv;


   function "/"(S,T: CoBall) return CoBall is
   begin
      if Contains(T,CoBall_Zero) then
         New_Line;
         Message("CoBalls.Ops./",Division_By_Zero);            -- division by zero
      end if;
      return S*Inv(T);
   end "/";


   function Power(S: CoBall; I: Integer) return CoBall is
   begin
      if I>0 then
         declare
            J: Integer := I;
            X,Y: CoBall;
         begin
            X := S;
            if (J rem 2)=0 then
               Y :=CoBall_One;
            else
               Y := X;
            end if;
            J := J/2;
            while J>0 loop
               X := Sqr(X);
               if (J rem 2)>0 then
                  Y := X*Y;
               end if;
               J := J/2;
            end loop;
            return Y;
         end;
      elsif I<0 then
         return Power(Inv(S),-I);
      else
         return CoBall_One;
      end if;
   end Power;


   function "**"(S: CoBall; I: Integer) return CoBall is
   E: constant CoBall:=Ball0(ErrPart(S));
   begin
      if S=CoBall_One then
         return CoBall_One;
      end if;
      if S=CoBall_Zero and I>=0 then
         return CoBall_Zero;
      end if;
      if S=CoBall_Zero and I<0 then
         Message("**.CoBalls-Ops",Division_By_Zero);
      end if;
      if I>0 then
         declare
            J: Integer := I;
            X,Y,Xa,Ya,Yp: CoBall;
         begin
            X := S;
            Xa:=ResetErr(S);
            if (J rem 2)=0 then
               Y :=CoBall_One;
               Ya :=CoBall_One;
            else
               Y := X;
               Ya := Xa;
            end if;
            J := J/2;
            while J>0 loop
               Yp:=Y;
               X := Sqr(X);
               Xa:=Sqr(Xa);
               if (J rem 2)>0 then
                  Y := X*Y;
                  Ya:=Xa*Ya;
               end if;
               J := J/2;
            end loop;
            return Ya+Rep(I)*E*Yp;
         end;
      elsif I<0 then
         return Inv(S)**(-I);
      else
         return CoBall_One;
      end if;
   end "**";


   procedure CoshSinh(S: in CoBall; Sc,Ss: out CoBall) is
      Iter: constant Integer := 32;
   begin
      if S = CoBall_One then
         Sc := CoBall_One;
         Ss := S;
      else
         declare
            K: Integer;
            R: Rep;
            X,T: CoBall;
         begin
            K := 0;
            R := SupMod(S);
            while R>Half loop --reduses the modulus of S, so that |S|<1/2
               K := K+1;
               R := R*Half;
            end loop;
            X := (SetBall(Complecs(Half,Zero),Zero)**K)*S;
            T := Sqr(X);
            Sc := Complecs(One,Half);
            Ss := Sc;
            for I in reverse 1 .. Iter loop
               Sc := CoBall_One+Sc*(T/Rep((2*I)*(2*I-1)));
               Ss := CoBall_One+Ss*(T/Rep((2*I)*(2*I+1)));
            end loop;
            Ss := X*Ss;
            for I in 1 .. K loop
               T := Sc;
               Sc := CoBall_One+Two*Sqr(Ss);
               Ss := Two*(T*Ss);
            end loop;
         end;
      end if;
   end CoshSinh;


   function Cosh(S: CoBall) return CoBall is
      Sc,Ss: CoBall;
   begin
      CoshSinh(S,Sc,Ss);
      return Sc;
   end Cosh;


   function Sinh(S: CoBall) return CoBall is
      Sc,Ss: CoBall;
   begin
      CoshSinh(S,Sc,Ss);
      return Ss;
   end Sinh;


   procedure CosSin(S: in CoBall; Sc,Ss: out CoBall) is
      Iter: constant Integer := 32;
      Co: CoBall;
   begin
      if S = CoBall_Zero then
         Sc := CoBall_One;
         Ss := S;
      else
         declare
            K: Integer;
            R: Rep;
            X,T: CoBall;
         begin
            K := 0;
            R := SupMod(S);
            while R>Half loop --reduses the modulus of S, so that |S|<1/2
               K := K+1;
               R := R*Half;
            end loop;
            X := (SetBall(Complecs(Half,Zero),Zero)**K)*S;
            T := Sqr(X);
            Sc := Complecs(One,Half);
            Ss := Sc;
            if ((Iter-1) mod 2)=0 then
               Co:=CoBall_One;
            else
               Co:=Neg(CoBall_One);
            end if;
            for I in reverse 1 .. Iter loop
               Sc := Co+Sc*(T/Rep((2*I)*(2*I-1)));
               Ss := Co+Ss*(T/Rep((2*I)*(2*I+1)));
               Co:=Neg(Co);
            end loop;
            Ss := X*Ss;
            for I in 1 .. K loop
               T := Sc;
               Sc := CoBall_One-Two*Sqr(Ss);
               Ss := Two*(T*Ss);
            end loop;
         end;
      end if;
   end CosSin;


   function Cos(S: CoBall) return CoBall is
      Sc,Ss: CoBall;
   begin
      CosSin(S,Sc,Ss);
      return Sc;
   end Cos;


   function Sin(S: CoBall) return CoBall is
      Sc,Ss: CoBall;
   begin
      CosSin(S,Sc,Ss);
      return Ss;
   end Sin;


   function Exp(S: CoBall) return CoBall is
   begin
      if S=CoBall_Zero then return CoBall_One; end if;   -- S=0
      declare
         X,Y: CoBall;
      begin
         if Contains(S,CoBall_Zero) then                               -- S contains 0
            CoshSinh(S,X,Y);
            return X+Y;
         end if;
         declare
            Iter: constant Integer := 32;
            K: Integer := 0;
            R: Rep;
         begin
            R := SupMod(S);
            while R>Quarter loop
               K := K+1;
               R := R*Half;
            end loop;
            X := (SetBall(Complecs(Half,Zero),Zero)**K)*S;
            Y := SetBall(CoBall_Zero,Three/Two);
            for I in reverse 1 .. Iter loop
               Y := CoBall_One+(X*Y)/Rep(I);
            end loop;
            for I in 1 .. K loop
               Y := Sqr(Y);
            end loop;
            return Y;
         end;
      end;
   end Exp;


   function EiExp(S1,S2: CoBall; NumErr: Rep:=Rep(1.0E-15)) return CoBall is
      G: constant CoBall:=SetBall(Scal(0.57721566490153285,0.57721566490153287),Scal(Zero));
      Interval_Pi: constant Interval:=Scal(Rep(3.14159_26535_89793_23),Rep(3.14159_26535_89793_24));
      Interval_One: constant Interval:=Scal(One);
      Y,X,Xa,Ya,Rn,Rna: CoBall;
      S1a: constant CoBall:=ResetErr(S1);
      S2a: constant CoBall:=ResetErr(S2);
      S2u: constant Interval:=AbsVal(S2a);
      ErB: constant CoBall:=Ball0(ErrPart(S2));
      C,C1,Xu,U: Interval;
      K: Integer:=0;
      J: Integer;
      Er: Rep:=Rep(1.0E+100);
      Co: CoBall:=CoBall_One;
   begin
      Y:=CoBall_One;
      Ya:=Y;
      X:=CoBall_One;
      Xa:=X;
      J:=1;
      while Er>SupMod(NumErr*Ya) loop
         X:=Rep(J)*Prod(X,S1);
         Xa:=Rep(J)*Prod(Xa,S1a);
         Y:=Y+X;
         Ya:=Ya+Xa;
         J:=J+1;
         Er:=SupMod(Xa);
         if Er>Rep(1.0E+100) then goto SECOND; end if;
      end loop;
      if  Sup(RePart(S2))>Zero then
         Rna:=Rep(J)*(AbsVal(S2a)-abs(ImPart(S2a))+Interval_One)*Ball0(Xa*S1a);
         Rn:=Rep(J)*(AbsVal(S2)-abs(ImPart(S2))+Interval_One)*Ball0(X*S1);
      else
         Rna:=Rep(J)*Ball0(Xa*S1a);
         Rn:=Rep(J)*Ball0(X*S1);
      end if;
      return (Ya+Rna)*S1a  +  ErB*(Neg((Y+Rn)*S1)+S1);
      <<SECOND>> null;
      Y:=CoBall_Zero;
      X:=CoBall_One;
      Xu:=Interval_One;
      U:=Interval_One;
      C1:=Interval_One;
      J:=1;
      while Er>SupMod(NumErr*Y) loop
         C1:=C1/Rep(J);
         C:=C1/Rep(J);
         X:=X*S2a;
         Xu:=Xu*S2u;
         Y:=Y+C*X;
         U:=U+C1*Xu;
         J:=J+1;
         Er:=SupMod(C*X);
      end loop;
      --error <= exp(-z)*[exp(|z|)-sum^J_0 |z|^k/k]/(J+1)
      return  Exp(Neg(S2))*(G+Log(Neg(S2a))+Y+Ball0(Sup(abs( (Exp(S2u)-U)/Rep(J) ) ) ) ) +ErB*S1;
   end EiExp;


     function Log(S: CoBall) return CoBall is
   begin
      if Check  and  Contains(S,CoBall_Zero) then
         Message("CoBalls.Ops.Log",Zero_In_Log);
      end if;
      if S=CoBall_One then return CoBall_Zero; end if;
      declare
         Iter: constant Integer := 64;
         S0,LogS0,X,Y: CoBall;
         R: Interval;
         Co: CoBall:=CoBall_One;
      begin
         LogS0 :=Complecs(Half*Log(Re(S.C)*Re(S.C)+Im(S.C)*Im(S.C)),Argument(S.C));   --- guess
         S0 := Exp(LogS0);
         if Contains(S0,CoBall_Zero) then
            Message("CoBalls.Ops.Log",Division_By_Zero);
         end if;
         X := (S0-S)/S0;
         R := Scal(SupMod(X));
         Y := CoBall_Zero;
         for I in reverse 1 .. Iter loop
            Y := CoBall_One/Rep(I)+X*Y;
         end loop;
         return LogS0-X*Y+Ball0(Sup(R**(Iter+1)/Rep(Iter+1)));
      end;
   end Log;

--   function Log(S: CoBall) return CoBall is
--   begin
--      if Check  and  Contains(S,CoBall_Zero) then
--         Message("CoBalls.Ops.Log",Zero_In_Log);
--      end if;
--      if S=CoBall_One then return CoBall_Zero; end if;
--      declare
--         Iter: constant Integer := 64;
--         S0,LogS0,X,Y: CoBall;
--         R: Interval;
--         Co: CoBall:=CoBall_One;
--      begin
--         LogS0 :=Complecs(Half*Log(Re(S.C)*Re(S.C)+Im(S.C)*Im(S.C)),Argument(S.C));   --- guess
--         S0 := Exp(LogS0);
--         if Contains(S0,CoBall_Zero) then
--            Message("CoBalls.Ops.Log",Division_By_Zero);
--         end if;
--         X := (S0-S)/S0;
--         R := Scal(One)-AbsVal(X);
--         if Inf(R) <= Zero then Message("CoBalls.Ops.Log",Zero_In_Log); end if;
--         Y := SetBall(CoBall_Zero,Sup(Inv(Rep(Iter+1)*R)) );
--         for I in reverse 1 .. Iter loop
--            Y := CoBall_One/Rep(I)+X*Y;
--         end loop;
--         return LogS0-X*Y;
--      end;
--   end Log;


   function Sqrt(S: CoBall) return CoBall is
   begin
      return Exp(Half*Log(S));
   end Sqrt;


   function Arg(C: CoBall) return Interval is
   begin
      return ImPart(Log(C));
   end Arg;


   function PiBall return CoBall is
      O,D: CoBall;
      Iter: constant Integer:=1000;
   begin
      O:=CoBall_One;
      D:=O+SetBall(Complecs(Rep(Iter+1),Zero),Zero)/SetBall(Complecs(Rep(3+2*Iter),Zero),Zero);
      for I in reverse 1 .. Iter loop
         D:=D*SetBall(Complecs(Rep(I),Zero),Zero)/SetBall(Complecs(Rep(3+2*(I-1)),Zero),Zero)+O;
      end loop;
      return  Two*D;
   end PiBall;

begin

   Round_Up;

end CoBalls.Ops;
