with Intervals.Ops;
use Intervals.Ops;
package CoBalls.Ops is

   pragma Elaborate_Body;

   function Contains(S: CoBall; C: CoBall) return Boolean;
   function Intersects(S: CoBall; T: CoBall) return Boolean;
   function SetBall(R1,R2: Interval) return CoBall;
   function RePart(C: CoBall) return  Interval;
   function ImPart(C: CoBall) return Interval;
   function InfRe(S: CoBall) return Rep;
   function SupRe(S: CoBall) return Rep;
   function InfIm(S: CoBall) return Rep;
   function SupIm(S: CoBall) return Rep;
   function SupMod(S: CoBall) return Rep;
   function InfMod(S: CoBall) return Rep;
   procedure ErrMult(R: in Rep; S: in out CoBall);
   function Cap(R: Radius; S: CoBall) return CoBall;
   function MaxMod(S1,S2: CoBall) return CoBall;
   function PiBall return CoBall;
   procedure RandomBall(Seed: in out Long_Integer; S: out CoBall);

   function "+"(S,T: CoBall) return CoBall;
   function "-"(S,T: CoBall) return CoBall;
   function "*"(R: Rep; S: CoBall) return CoBall;
   function "/"(S: CoBall; R: Rep) return CoBall;
   function "*"(R: Interval; S: CoBall) return CoBall;
   function "/"(S: CoBall; R: Interval) return CoBall;
   function "*"(S,T: CoBall) return CoBall;
   function "/"(S,T: CoBall) return CoBall;
   function "**"(S: CoBall; I: Integer) return CoBall;
   function Power(S: CoBall; I: Integer) return CoBall;
   function AbsBall(S: CoBall) return CoBall;
   function AbsVal(S: CoBall) return Interval;
   function Arg(C: CoBall) return Interval;
   function Neg(S: CoBall) return CoBall;
   function Sqr(S: CoBall) return CoBall;
   function Inv(S: CoBall) return CoBall;
   function Long_Inv(S: CoBall) return CoBall;
   function Cosh(S: CoBall) return CoBall;
   function Sinh(S: CoBall) return CoBall;
   function Cos(S: CoBall) return CoBall;
   function Sin(S: CoBall) return CoBall;
   function Exp(S: CoBall) return CoBall;
   function EiExp(S1,S2: CoBall; NumErr: Rep:=Rep(1.0E-15)) return CoBall;
   function Log(S: CoBall) return CoBall;
   function Sqrt(S: CoBall) return CoBall;

   pragma Inline (RePart,ImPart,Contains,Intersects,SetBall,AbsVal,Arg,InfRe,SupRe,InfIm,SupIm,SupMod,InfMod,AbsBall,ErrMult,Neg,RandomBall,"+","-","*","/","*",Sqr,Inv,Long_Inv,Cap,MaxMod);
   pragma Inline_Always (RePart,ImPart,Contains,Intersects,SetBall,AbsVal,Arg,InfRe,SupRe,InfIm,SupIm,SupMod,InfMod,AbsBall,ErrMult, Neg,RandomBall,"+","-","*","/","*",Sqr,Inv,Long_Inv,Cap,MaxMod);

private

  procedure CoshSinh(S: in CoBall; Sc,Ss: out CoBall);
  procedure CosSin(S: in CoBall; Sc,Ss: out CoBall);
end CoBalls.Ops;
