with Reps.Ops;
use Reps.Ops;

package body CoBalls is

   function SetBall(C: CoBall;R: Rep:=Zero) return CoBall is
   begin
      return (C.C,R);
   end SetBall;


   function Conj(C: CoBall) return CoBall is
   begin
      return ((Re(C.C),-Im(C.C)),C.R);
   end Conj;


   function IsCoNumber(S: CoBall) return Boolean is
   begin
      return False;
   end IsCoNumber;


   function IsBall(S: CoBall) return Boolean is
   begin
      return True;
   end IsBall;


   function Complecs(Re,Im: Rep) return CoBall is
   begin
      return ((Re,Im),Zero);
   end Complecs;


   function Ball0(R: Rep) return CoBall is
   begin
      return ((Zero,Zero),R);
   end Ball0;

   function Ball0(R: CoBall) return CoBall is
   begin
      return ((Zero,Zero),Sqrt(Re(R.C)*Re(R.C)+Im(R.C)*Im(R.C))+R.R);
   end Ball0;


   function Center0(S: CoBall) return Boolean is
      use Complex_Types;
   begin
      return S.C=(Zero,Zero);
   end Center0;


   function Err0(S: CoBall) return Boolean is
   begin
      return S.R=Zero;
   end Err0;


   function CenterBall(S: CoBall) return CoBall is
   begin
      return (S.C,Zero);
   end;


   function ErrPart(S: CoBall) return Rep is
   begin
      return S.R;
   end ErrPart;


   procedure ResetCenter(S: in out CoBall) is
   begin
      S.C := (Zero,Zero);
   end ResetCenter;


   function ResetCenter(S: CoBall) return CoBall is
   begin
      return ((Zero,Zero),S.R);
   end ResetCenter;


   procedure Split(S: in CoBall; Sr,Se: out CoBall) is
   begin
      Sr := (S.C,Zero);
      Se := ((Zero,Zero),S.R);
   end Split;


   procedure ResetErr(S: in out CoBall) is
   begin
      S.R := Zero;
   end ResetErr;


   function ResetErr(S: CoBall) return CoBall is
   begin
      return (S.C,Zero);
   end ResetErr;


end CoBalls;
