with Reps.Ops,Reps.IO;
use Reps.Ops,Reps.IO;

package body CoNumbers.IO is


   package Txt_CoNumbers_IO is new Ada.Text_IO.Complex_IO(Complex_Typo);
   use  Txt_CoNumbers_IO;


   procedure Show(C: in CoNumber; Cut: in Rep:=Zero) is
   begin
--      if Sqrt(Sqr(Re(C))+Sqr(Im(C)))>Cut then
         Put("(");
         Txt_Put(Current_Output,Re(C));
         Put(",");
         Txt_Put(Current_Output,Im(C));
         Put(")");
--      end if;
   end Show;


   procedure Get(F: in File_Type; C: out CoNumber;  Brackets: in Boolean:=False; Decimal: in Boolean := True;ShowErr: in Boolean:=True) is
      R1,R2,R3: Rep;
   begin
      Txt_Get(F,R1,R2,Decimal);
      C:=SetBall(Complecs(R1,R2));
      if ShowErr then
         Txt_Get(F,R3,Decimal);
      end if;
   end Get;


   procedure Put(F: in File_Type; C: in CoNumber; Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in Boolean:=True) is
   begin
      if Brackets=True then
         Put(F,"(");
      end if;
      Txt_Put(F,Re(C),Decimal);
      Put(F," ");
      if Brackets then
         Put(F,",");
      end if;
      Txt_Put(F,Im(C),Decimal);
      if Brackets then
         Put(F,")");
      end if;
      if ShowErr then
         if Brackets then
            Put(F,"[");
         end if;
         Txt_Put(F,Zero,Decimal);
         if Brackets then
            Put(F,"]");
         end if;
      end if;
   end Put;


end CoNumbers.IO;

