package CoNumbers.Ops is

   pragma Elaborate_Body;

   package Complex_Func is new Ada.Numerics.Generic_Complex_Elementary_Functions(Complex_Typo);
   use Complex_Func;

   function Contains(S: CoNumber; C: CoNumber) return Boolean;
   function Intersects(S: CoNumber; T: CoNumber) return Boolean;
   function SetBall(R1,R2: Numeric) return CoNumber;
   function RePart(C: CoNumber) return  Numeric;
   function ImPart(C: CoNumber) return Numeric;
   function InfRe(S: CoNumber) return Rep renames Re;
   function SupRe(S: CoNumber) return Rep renames Re;
   function InfIm(S: CoNumber) return Rep renames Im;
   function SupIm(S: CoNumber) return Rep renames Im;
   function SupMod(S: CoNumber) return Rep renames "abs";
   function InfMod(S: CoNumber) return Rep renames "abs";
   procedure ErrMult(R: in Rep; S: in out CoNumber);
   function Cap(R: Radius; S: CoNumber) return CoNumber;
   function MaxMod(S1,S2: CoNumber) return CoNumber;
   function PiBall return CoNumber;
   procedure RandomBall(Seed: in out Long_Integer; C: out CoNumber);

   function "+"(S,T: CoNumber) return CoNumber renames Complex_Typo."+";
   function "-"(S,T: CoNumber) return CoNumber renames Complex_Typo."-";
   function "*"(R: Rep; S: CoNumber) return CoNumber renames Complex_Typo."*";
   function "*"(R: Numeric; S: CoNumber) return CoNumber;
   function "*"(S,T: CoNumber) return CoNumber renames Complex_Typo."*";
   function "/"(S: CoNumber; R: Rep) return CoNumber renames Complex_Typo."/";
   function "/"(S: CoNumber; R: Numeric) return CoNumber;
   function "/"(S,T: CoNumber) return CoNumber renames Complex_Typo."/";
   function "**"(S: CoNumber; I: Integer) return CoNumber renames Complex_Typo."**";
   function AbsBall(S: CoNumber) return CoNumber;
   function AbsVal(S: CoNumber) return Numeric;
   function Arg(S: CoNumber) return Numeric;
   function Neg(S: CoNumber) return CoNumber renames Complex_Typo."-";
   function Sqr(S: CoNumber) return CoNumber;
   function Inv(S: CoNumber) return CoNumber;
   function Long_Inv(S: CoNumber) return CoNumber;
   function Exp(S: CoNumber) return CoNumber;
   function Log(S: CoNumber) return CoNumber;
   function EiExp(S1,S2: CoNumber; NumErr: Rep:=Rep(1.0E-15)) return CoNumber;
   function Cosh(S: CoNumber) return CoNumber renames Complex_Func.Cosh;
   function Sinh(S: CoNumber) return CoNumber renames Complex_Func.Cosh;
   function Cos(S: CoNumber) return CoNumber renames Complex_Func.Cos;
   function Sin(S: CoNumber) return CoNumber renames Complex_Func.Sin;
   function Sqrt(S: CoNumber) return CoNumber renames Complex_Func.Sqrt;

   pragma Inline (RePart,ImPart,Arg,Contains,Intersects,InfRe,SupRe,InfIm,SupIm,SupMod,InfMod,AbsBall,ErrMult, Neg,Sqr,Inv,Long_Inv,Log,Cap,MaxMod);
   pragma Inline_Always (RePart,ImPart,Arg,Contains,Intersects,InfRe,SupRe,InfIm,SupIm,SupMod,InfMod,AbsBall,ErrMult,Neg,Sqr,Inv,Long_Inv,Log,Cap,MaxMod);

end CoNumbers.Ops;
