with Reps, Ada.Numerics.Generic_Complex_Types,  Ada.Numerics.Generic_Complex_Elementary_Functions, Numerics;
use Reps,Numerics;

package CoNumbers is

   pragma Pure;

   package Complex_Typo is new Ada.Numerics.Generic_Complex_Types(Rep);
   use Complex_Typo;

   subtype CoNumber is Complex;

   function Conj(C: CoNumber) return CoNumber;
   function SetBall(C: CoNumber; R: Rep:=Zero) return CoNumber;
   function IsCoNumber(S: CoNumber) return Boolean; --returns True
   function IsBall(S: CoNumber) return Boolean; --returns False
   function Complecs(Re,Im: Rep) return CoNumber; --returns a ball with the specified center and zero radius
   function Ball0(R: Rep) return CoNumber; --returns a ball with the zero center and specified radius
   function Ball0(R: CoNumber) return CoNumber; --returns a ball with the zero center and specified radius
   function Center0(S: CoNumber) return Boolean; --checks if the center is zero
   function Err0(S: CoNumber) return Boolean; --checks if the radius is zero
   function ErrPart(S: CoNumber) return Rep; --returns the radius
   procedure ResetCenter(S: in out CoNumber); --zeros the center
   function ResetCenter(S: CoNumber) return CoNumber; -- zeros the center
   procedure Split(S: in CoNumber; Sr,Se: out CoNumber); --splits a ball into a ball with the original center a nd zero radius and a ball with the zero center and the original radius
   procedure ResetErr(S: in out CoNumber);
   function ResetErr(S: CoNumber) return CoNumber;
   function CenterBall(S: CoNumber) return CoNumber; --returns the center

   pragma Inline (Ball0,Conj,SetBall,IsCoNumber,IsBall,Complecs,Ball0,Center0,Err0,ErrPart, ResetCenter, ResetCenter,Split,ResetErr,CenterBall);
   pragma Inline_Always (Ball0,Conj,SetBall,IsCoNumber,IsBall,Complecs,Ball0,Center0,Err0,ErrPart, ResetCenter, ResetCenter,Split,ResetErr, CenterBall);

end CoNumbers;


