with Reps, Reps.Ops, Reps.IO, Messages, RG_Ops, Ada.Numerics.Generic_Elementary_Functions,Ada.Characters.Latin_1, Round_Up,Intervals, Intervals.Ops, Intervals.IO;
with CoBalls, CoBalls.Ops, CoBalls.IO, Ada.Text_IO,Ada.Float_Text_IO, GetOpt, Ada.Command_Line,  Ada.Strings.Unbounded;
use Reps, Reps.Ops, Reps.IO, Messages, Intervals, Intervals.Ops, Intervals.IO,CoBalls, CoBalls.Ops, CoBalls.IO,Ada.Text_IO,Ada.Float_Text_IO,GetOpt, Ada.Command_Line, Ada.Strings.Unbounded;

pragma Elaborate_All(Intervals.Ops);
pragma Elaborate_All(CoBalls.Ops,CoBalls.IO);
pragma Elaborate_All(Reps.Ops);
pragma Elaborate_All (RG_Ops);

procedure Form_Grid is

   pragma Suppress(Storage_Check);

   Pdeg:constant Positive:=3000;
   Dho: constant Natural:=3000;
   subtype Scalar is Interval;
   subtype Comp is CoBall;
   package Current_RG is new RG_Ops(Pdeg,Dho,Scalar,Comp);
   use Current_RG;
   use RG_Tay,RG_Tay_Ops,RG_Tay_IO;
   package Txt_Int_IO is new Ada.Text_IO.Integer_IO(Integer);
   use Txt_Int_IO;

   Test_String : String := "n:m:o:r:i:j:t:c:k:q:v:y:a:";
   ActR,R,Inc1,Inc2,Inc3: Rep;
   J,MaxN,N,M,Va,K,Q: Integer;
   Optchar : character;
   Tay_File,Out_Dir: Unbounded_String;
   ShowErr: Boolean;
   IsPoly: Boolean:=True;
   GetPoly: constant Boolean:=False;
   Brackets: constant Boolean:=False;
   Decimal: constant Boolean:=True;
begin
   --DEAFULT OPTIONS
   N:=100000;
   M:=64;
   Out_Dir:=To_Unbounded_String("/home/gaidash/numerics_data/");
   Tay_File:=To_Unbounded_String("/home/gaidash/numerics_data/taylor");
   Inc1:=Rep(1.0E-6);
   Inc2:=Rep(1.000001);
   Inc3:=Rep(1.0E-3);
   Rho:=Rep(2.2);
   K:=1;
   Q:=1;

   --OPTIONS
   Getopt.Opterr := 1;
   loop
      Va := Getopt.Getopt( Test_String );
      exit when Va = -1;
      optchar :=  Character'Val( Va );
      case optchar is
         when 'o' =>
            Out_Dir:=To_Unbounded_String(To_String(Getopt.Optarg));
         when 't' =>
            Tay_File:=To_Unbounded_String(To_String(Getopt.Optarg));
         when 'k' =>
            K:=Integer'Value(To_String(Getopt.Optarg));
         when 'n' =>
            MaxN:=Integer'Value(To_String(Getopt.Optarg));
         when 'm' =>
            M:=Integer'Value(To_String(Getopt.Optarg));
         when 'r' =>
            Rho:=Rep'Value(To_String(Getopt.Optarg));
         when 'i' =>
            R:=Rep'Value(To_String(Getopt.Optarg));
         when 'a' =>
            ActR:=Rep'Value(To_String(Getopt.Optarg));
         when 'c' =>
            Inc1:=Rep'Value(To_String(Getopt.Optarg));
         when 'j' =>
            Inc2:=Rep'Value(To_String(Getopt.Optarg));
         when 'y' =>
            Inc3:=Rep'Value(To_String(Getopt.Optarg));
         when 'q' =>
            Q:=Integer'Value(To_String(Getopt.Optarg));
         when others =>
            New_Line;
            Message("wrong option",Parameter_Error);
      end case;
   end loop;

   if Q=1 then
      Quad:=True;
   elsif Q=0 then
      Quad:=False;
   else
      New_Line;
      Message("Wrong option in Form_Grid",Parameter_Error);
   end if;

   declare
      Dir: String:=To_String(Out_Dir);
      Radial_Grid: String:=Dir & "rads/radii";
      VarRho_File: String:=Dir & "rads/varrho";
      ActRad_File: String:=Dir & "rads/act_rad";
      RadScal_Grid: String:=Dir & "rads/thick_radii";
      Rho_Grid: String:=Dir & "rads/rhos";
      Periodic_File: String:=Dir & "points/approx_periodic_points";
      P_File: String:=Dir & "points/periodic_point";
      Cr_File: String:=Dir & "points/cr_point";
      Cn_File: String:=Dir & "points/cn_point";
      Cn2_File: String:=Dir & "points/cn2_point";
      Cn2n_File: String:=Dir & "points/cn2n_point";
      StRad,RR,Eps: Rep;
      VarRho: Scalar;
      Sw,Qnmin1,Qnmin2,Qnplus1,Qnplus2: Integer;
      Cn,CrPointt,Ind_P: Comp;
      F,F1,F2: File_Type;
      Tmp,Tay,IterTay,DerIterTay: Taylor;
   begin
      Qnmin1:=0;
      Qn:=1;
      Qnplus1:=2;
      Qnplus2:=3;
      for I in 2..K loop
         if I=2 then
            Qnmin2:=0;
            Qnmin1:=1;
            Qn:=2;
            Qnplus1:=3;
            Qnplus2:=5;
         else
            Qnmin2:=Qnmin1;
            Qnmin1:=Qn;
            Qn:=Qnmin2+Qnmin1;
            Qnplus1:=Qn+Qnmin1;
            Qnplus2:=Qnplus1+Qn;
         end if;
      end loop;

      --READING TAYLOR
      New_Line;
      Put("Reading the Taylor series ...");
      ShowErr:=False;
      Open(F,In_File,To_String(Tay_File));
      Get(Rho,F,Tay,IsPoly,GetPoly,Brackets,Decimal,ShowErr);
      Close(F);
      ShowErr:=True;
      Put(" done");

      IterTay:=Tay;
      for I in 1..Qn-1 loop
         IterTay:=Compose(IterTay,Tay);
      end loop;
      New_Line;
      Put("Itterated Taylor series:");
      New_Line;
      Show(IterTay);
      New_Line;


      Put("Reading and computing points ...");
      Open(F,In_File,Periodic_File);
      Set_Line(F,Ada.Text_IO.Count(K));
      ShowErr:=True;
      Get(F,P,Brackets,Decimal,ShowErr);
      Close(F);
      Tmp:=IterTay;
      AddComponent(1,Neg(CoOne),Tmp);
      Newton(1,Rho,P,Tmp,CoZero,IsPoly);
      CrPointt:=CoOne;
      Der(Rho,Rep(0.95)*Rho,IterTay,DerIterTay,IsPoly);
      Newton(1,Rho,CrPointt,DerIterTay,CoZero,IsPoly);
      Ind_P:=CoZero;
      Cn2:=Val(Qnplus2,Rho,CrPointt,Tay);
      Cn:=Val(Qn,Rho,CrPointt,Tay);
      Cn2n:=Val(Qn,Rho,Cn2,Tay);
      LogB:=Neg(IBall)*Log(CoOne-P/Cn2);--image of C_{n+2} under inverse tau
      LogA:=AbsVal( Log(  (Cn2n-P)*Cn2/((Cn2-P)*Cn2n)  )  );
      LogBB:=LogB;
      Put(" done");

      Put("Writing points...");
      ShowErr:=True;
      Create(F,Out_File,P_File);
      Put(F,P,Brackets,Decimal,ShowErr);
      Close(F);
      Create(F,Out_File,Cr_File);
      Put(F,CrPointt,Brackets,Decimal,ShowErr);
      Close(F);
      Create(F,Out_File,Cn_File);
      Put(F,Cn,Brackets,Decimal,ShowErr);
      Close(F);
      Create(F,Out_File,Cn2_File);
      Put(F,Cn2,Brackets,Decimal,ShowErr);
      Close(F);
      Create(F,Out_File,Cn2n_File);
      Put(F,Cn2n,Brackets,Decimal,ShowErr);
      Close(F);
      Put("done");


      New_Line;
      Put("c=");Show(CrPointt);
      New_Line;
      Put("p=");Show(P);
      New_Line;
      Put("ind. point=");Show(Ind_P,-One);
      New_Line;
      New_Line;

      --DEFINING THE RADIAL GRID
      VarRho:=Scal(0.0001);
      Eps:=Inc1*Inf(VarRho);
      RR:=Approx( Scal(Inf(VarRho),Inf(VarRho+Half*Scal(Eps)) )  );
      J:=2;
      New_Line;
      Put("Minimal increment=");Txt_Put(Current_Output,Eps);

      Sw:=0;
      while RR<R loop
         --Eps:=Inc1*RR;
         if Eps<Inc3 then
         Eps:=Inc2*Eps;
         else
         Eps:=Inc3;
         if Sw=0 then
         StRad:=RR;
         New_Line;
         Put("Uniform grid begins at R=");Txt_Put(Current_Output,StRad);
         Sw:=1;
         end if;
         end if;
         RR:=RR+Eps;
         J:=J+1;
         if (RR>ActR and (RR-Eps)<ActR) then
            N:=J;
         end if;
      end loop;
      New_Line;
      Put("Maximal increment=");Txt_Put(Current_Output,Eps);

      New_Line;
      Put("Active parameter range is covered by ");ShortPut(N);Put(" radii");
      New_Line;
      Put("Total number of radii is ");ShortPut(J);
      New_Line;
      declare
         N1: constant Integer:=-N;
         N2: constant Integer:=0;
         N3: constant Integer:=J-N;
         Rad,ThickRad: ScalArray(N1..N3);
         Ro: ScalArray(N1-1..N2);
      begin

         --CONSTRUCTING AND WRITING THE RADIAL GRID
         New_Line;
         Put("Constructing and writing the grid...");
         ThickRad(Rad'First):=Scal(Zero,Inf(VarRho));
         Eps:=Inc1*Inf(VarRho);
         ThickRad(Rad'First+1):=Scal(Inf(VarRho),Inf(VarRho+Half*Scal(Eps)) );

         Rad(Rad'First):=ScalZero;
         Rad(Rad'First+1):=Scal(Approx( ThickRad(Rad'First+1) ));

         Ro(Ro'First):=ScalZero;
         Ro(Rad'First):=Scal(Sup( ThickRad(Rad'First) )  );
         Ro(Rad'First+1):=Scal(Sup( ThickRad(Rad'First+1) )  );

         for I in Rad'First+2..Rad'Last loop
            --Eps:=Approx(Inc1*Rad(I-1));
            if Eps<Inc3 then
            Eps:=Inc2*Eps;
            else
            Eps:=Inc3;
            end if;
            ThickRad(I):=Scal(Sup(ThickRad(I-1)),Sup(ThickRad(I-1))+Eps);
            Rad(I):=Scal(Approx( ThickRad(I) ));
            Ro(I):=Scal(Sup( ThickRad(I) ) );
         end loop;

         Create(F,Out_File,Radial_Grid);
         Create(F1,Out_File,RadScal_Grid);
         Create(F2,Out_File,Rho_Grid);

         Put(F,Rad'First);  Put(F,Rad'Last);  Put(F,M);
         New_Line(F);

         Put(F1,Rad'First);  Put(F1,Rad'Last); Put(F1,M);
         New_Line(F1);

         Put(F2,Ro'First);  Put(F2,Ro'Last);  Put(F2,M);
         New_Line(F2);

         Txt_Put(F2,Approx(Ro(Ro'First)));
         New_Line(F2);
         for I in Rad'Range loop
            Txt_Put(F,Approx(Rad(I)));
            New_Line(F);
            Put(F1,ThickRad(I));
            New_Line(F1);
            if I<=Ro'Last then
               Txt_Put(F2,Approx(Ro(I)));
               New_Line(F2);
            end if;
         end loop;
         Close(F2);
         Close(F1);
         Close(F);
      end;
      Put("Done");
   end;
end Form_Grid;



























