with Reps, Reps.Ops, Reps.IO, Messages, RG_Ops,
Ada.Numerics.Generic_Elementary_Functions,Ada.Characters.Latin_1,Round_Up,  Ada.Text_IO,Ada.Float_Text_IO,  Ada.Command_Line, GetOpt,  Ada.Strings.Unbounded;
--with CoBalls, CoBalls.Ops, CoBalls.IO, Intervals, Intervals.Ops, Intervals.IO;
--use Intervals, Intervals.Ops, Intervals.IO, CoBalls, CoBalls.Ops, CoBalls.IO;
with CoNumbers, CoNumbers.Ops, CoNumbers.IO, Numerics, Numerics.Ops, Numerics.IO;
use CoNumbers, CoNumbers.Ops, CoNumbers.IO, Numerics, Numerics.Ops, Numerics.IO;
use Reps, Reps.Ops, Reps.IO, Messages, Ada.Text_IO,Ada.Float_Text_IO, GetOpt, Ada.Command_Line, Ada.Strings.Unbounded;

--pragma Elaborate_All(Intervals.Ops);
--pragma Elaborate_All(CoBalls.Ops,CoBalls.IO);
pragma Elaborate_All(Numerics.Ops);
pragma Elaborate_All(CoNumbers.Ops,CoNumbers.IO);

pragma Elaborate_All(Reps.Ops);
pragma Elaborate_All (RG_Ops);

procedure Matrix_Column is

   pragma Suppress(Storage_Check);

   Pdeg:constant Positive:=1000;
   Dho: constant Natural:=1000;
--   subtype Scalar is Interval;
--   subtype Comp is CoBall;
   subtype Scalar is Numeric;
   subtype Comp is CoNumber;


   package Current_RG is new RG_Ops(Pdeg,Dho,Scalar,Comp);
   use Current_RG;
   use RG_Tay,RG_Tay_Ops,RG_Tay_IO;
   package Txt_Int_IO is new Ada.Text_IO.Integer_IO(Integer);
   use Txt_Int_IO;
   Test_String : String := "a:b:o:r:n:p:x:k:q:s:t:e:d:c:f:w:z:";
   X0,Y0,Radd,NumErr,Pex,SupAr,Eps,Delt: Rep;
   Co,Int1,Int2,L,I1,I2,Incr,Qa,K,M,N1,N2,Va,Num_Of_Machines, This_Machine: Integer;
   Rad: Scalar;
   DerRenTay_P: Taylor;
   Optchar : character;
   Tay_File_P,RenTay_File,RenTay_File_P,Out_Dir, CM: Unbounded_String;
   ShowErr,Compute: Boolean;
   IsPoly: Boolean:=True;
   GetPoly: constant Boolean:=False;
   Decimal: constant Boolean:=True;
   Brackets: constant Boolean:=False;
   ChangeSign: Boolean:=False;
begin
   --DEAFULT OPTIONS
   K:=1;
   NumErr:=Rep(1.0E-9);
   Out_Dir:=To_Unbounded_String("~/numerics_data/");
   Tay_File_P:=To_Unbounded_String("~/numerics_data/matrix/taylor_p");
   RenTay_File:=To_Unbounded_String("~/numerics_data/matrix/ren_taylor");
   RenTay_File_P:=To_Unbounded_String("~/numerics_data/matrix/ren_taylor_p");
   Rho:=Rep(2.2);
   Radd:=Rep(2.2);
   Pex:=Rep(2.1);
   Quad:=False;

   --OPTIONS
   Getopt.Opterr := 1;
   loop
      Va := Getopt.Getopt( Test_String );
      exit when Va = -1;

      optchar :=  Character'Val( Va );
      case optchar is
         when 'a' =>
            X0:=Rep'Value(To_String(Getopt.Optarg));
         when 'b' =>
            Y0:=Rep'Value(To_String(Getopt.Optarg));
         when 'o' =>
            Out_Dir:=To_Unbounded_String(To_String(Getopt.Optarg));
         when 'f' =>
            Tay_File_P:=To_Unbounded_String(To_String(Getopt.Optarg));
         when 'w' =>
            RenTay_File:=To_Unbounded_String(To_String(Getopt.Optarg));
         when 'z' =>
            RenTay_File_P:=To_Unbounded_String(To_String(Getopt.Optarg));
         when 'n' =>
            NumErr:=Rep'Value(To_String(Getopt.Optarg));
         when 'p' =>
            Pex:=Rep'Value(To_String(Getopt.Optarg));
         when 'r' =>
            Rho:=Rep'Value(To_String(Getopt.Optarg));
         when 's' =>
            Radd:=Rep'Value(To_String(Getopt.Optarg));
         when 'k' =>
            K:=Integer'Value(To_String(Getopt.Optarg));
         when 'q' =>
            Qa:=Integer'Value(To_String(Getopt.Optarg));
         when 'c' =>
            Co:=Integer'Value(To_String(Getopt.Optarg));
         when 'x' =>
            Num_Of_Machines:=Integer'Value(To_String(Getopt.Optarg));
         when 't' =>
            This_Machine:=Integer'Value(To_String(Getopt.Optarg));
         when 'e' =>
            Eps:=Rep'Value(To_String(Getopt.Optarg));
         when 'd' =>
            Delt:=Rep'Value(To_String(Getopt.Optarg));
         when others =>
            New_Line;
            Message("Wrong option in Renorm",Parameter_Error);
      end case;
   end loop;

   if Co=1 then
      Compute:=True;
   elsif Co=0 then
      Compute:=False;
   else
      New_Line;
      Message("Wrong Compute option in Renorm",Parameter_Error);
   end if;

   if not Compute then
      if This_Machine>1 then
         return;
      end if;
   end if; if Co=1 then
      Compute:=True;
   elsif Co=0 then
      Compute:=False;
   else
      New_Line;
      Message("Wrong Compute option in Renorm",Parameter_Error);
   end if;

   if not Compute then
      if This_Machine>1 then
         return;
      end if;
   end if;

   if Qa=1 then
      Quad:=True;
   elsif Qa=0 then
      Quad:=False;
   else
      New_Line;
      Message("Wrong Quad option in Renorm",Parameter_Error);
   end if;

   Rad:=Scal(Radd);

   declare
      Cont,GCont,GFCont,FCont: CompArray(1..2000);
      Del: Rep:=Two*Pi/Rep(Cont'Length);
      Dir: String:=To_String(Out_Dir);
      RadScal_Grid: String:=Dir & "rads/thick_radii";
      Rad_Grid: String:=Dir & "rads/radii";
      P_File: String:=Dir & "points/periodic_point";
      Cr_File: String:=Dir & "points/cr_point";
      Crit_File: String:=Dir & "points/crit_point";
      Centre_File: String:=Dir & "points/centre_point";
      ECrit_File: String:=Dir & "points/ecrit_point";
      ECentre_File: String:=Dir & "points/ecentre_point";
      Den_Image_EFeed_File: String:=Dir & "points/den_image_efeed_point";
      Cn_File: String:=Dir & "points/cn_point";
      Cn2_File: String:=Dir & "points/cn2_point";
      Cn2n_File: String:=Dir & "points/cn2n_point";
      EFeed_File: String:=Dir & "points/efeed_point";
      SolZeroVal_File: String:=Dir & "points/sol_val_at_zero";
      C_File: String:=Dir & "data/C_file";
      R_File: String:=Dir & "data/R_file";
      A_File: String:=Dir & "data/A_file";
      EP_File: String:=Dir & "Eps_file";
      Sol_File: String:=Dir & "g/approx_g_";
      Cont_File: String:=Dir & "contours/cont_file_" & Integer'Image(Num_Of_Machines)(2..Integer'Image(Num_Of_Machines)'Last);
      Cont_File_1: String:=Dir & "contours/image1_cont_file_" & Integer'Image(Num_Of_Machines)(2..Integer'Image(Num_Of_Machines)'Last);
      Cont_File_2: String:=Dir & "contours/image2_cont_file_" & Integer'Image(Num_Of_Machines)(2..Integer'Image(Num_Of_Machines)'Last);
      TCont_File: String:=Dir & "contours/tcont_file_"  & Integer'Image(Num_Of_Machines)(2..Integer'Image(Num_Of_Machines)'Last);
      TFCont_File: String:=Dir & "contours/tfcont_file_" & Integer'Image(Num_Of_Machines)(2..Integer'Image(Num_Of_Machines)'Last);
      FCont_File: String:=Dir & "contours/fcont_file_" & Integer'Image(Num_Of_Machines)(2..Integer'Image(Num_Of_Machines)'Last);
      ECont_File: String:=Dir & "contours/econt_file_" & Integer'Image(Num_Of_Machines)(2..Integer'Image(Num_Of_Machines)'Last);
      EFCont_File: String:=Dir & "contours/efcont_file_" & Integer'Image(Num_Of_Machines)(2..Integer'Image(Num_Of_Machines)'Last);
      GCont_File: String:=Dir & "contours/gcont_file_" & Integer'Image(Num_Of_Machines)(2..Integer'Image(Num_Of_Machines)'Last);
      GFCont_File: String:=Dir & "contours/gfcont_file_" & Integer'Image(Num_Of_Machines)(2..Integer'Image(Num_Of_Machines)'Last);
      Image_EFeed_File: String:=Dir & "points/image_efeed_point_" & Integer'Image(Num_Of_Machines)(2..Integer'Image(Num_Of_Machines)'Last);
      GCont_File_F: String:=Dir & "contours/gcont_file_";
      GFCont_File_F: String:=Dir & "contours/gfcont_file_";

      TR: Rep;
      R,Psii,AEP,ConstC: Scalar;
      Ind,Qnmin1,Qnmin2,Qnplus1,Qnplus2,K1,K2,J1,J2,Switch: Integer;
      CAppr,PP,Feed,FeedFCAppr,TFeed,EFeed,FCAppr,Val_At_Zero,Summa,Cr,ECr,TCr,GCr,Centre,TCentre,ECentre,GCentre,Cn,CrPointt,C1,C2,C22,C3,C4,C5,C,RD: Comp;
      F,F0,F1,F11,F12,F2,F3,F4,F5,F6,F7,F8,F9,F10: File_Type;
      Tay,Tmp,RenTay,Tay_P,RenTay_P: Taylor;
      MinGCont,MaxGCont,Diff: Rep;
      Seed: Long_Integer:=10;
   begin
      R:=ScalZero;--does not matter for the numerics
      AEP:=ScalZero; --does not matter for the numerics
      ConstC:=ScalZero; --does not matter for the numerics

      Qnmin1:=0;
      Qn:=1;
      Qnplus1:=2;
      Qnplus2:=3;
      for I in 2..K loop
         if I=2 then
            Qnmin2:=0;
            Qnmin1:=1;
            Qn:=2;
            Qnplus1:=3;
            Qnplus2:=5;
         else
            Qnmin2:=Qnmin1;
            Qnmin1:=Qn;
            Qn:=Qnmin2+Qnmin1;
            Qnplus1:=Qn+Qnmin1;
            Qnplus2:=Qnplus1+Qn;
         end if;
      end loop;

      --READING THE DIMENSIONS OF THE  GRID
      Open(F,In_File,RadScal_Grid);
      Get(F,N1); Get(F,N2); Get(F,M);
      Close(F);
      K1:=-M/2;
      K2:=M/2-1;

      declare
         ThickRad: ScalArray(N1..N2);
         V,VV: CompArray(K1..K2);
      begin
         New_Line;
         Put("Reading grid ...");
         Open(F,In_File,Rad_Grid);
         Set_Line(F,Ada.Text_IO.Count(2));
         for I in N1..N2 loop
            Txt_Get(F,TR);
            ThickRad(I):=Scal(TR);
            if TR>=Radd and TR<=Radd then
               Ind:=I;
            end if;
         end loop;
         Close(F);
         Put("done");
         New_Line;
         ShortPut(Ind);Put("-th row of the grid contains the contour");


         for I in 1..This_Machine loop
            delay 6.0;
         end loop;


         --BULDING THE OUTPUT
         Int1:=Integer'Image(This_Machine)'Length;
         Int2:=Integer'Image(Num_Of_Machines)'Length-1;
         CM:=To_Unbounded_String(Integer'Image(This_Machine)(2..Integer'Image(This_Machine)'Last));
         for I in Int1..Int2 loop
            CM:=To_Unbounded_String("0") & CM;
         end loop;

         New_Line;
         Put("CM=");Put(To_String(CM));
         Cont_File:=Dir & "contours/cont_file_" & To_String(CM);
         Cont_File_1:=Dir & "contours/image1_cont_file_" &  To_String(CM);
         Cont_File_2:=Dir & "contours/image2_cont_file_" &  To_String(CM);
         TCont_File:=Dir & "contours/tcont_file_"  &  To_String(CM);
         TFCont_File:=Dir & "contours/tfcont_file_" &  To_String(CM);
         FCont_File:=Dir & "contours/fcont_file_" &  To_String(CM);
         ECont_File:=Dir & "contours/econt_file_" &  To_String(CM);
         EFCont_File:=Dir & "contours/efcont_file_" &  To_String(CM);
         GCont_File:=Dir & "contours/gcont_file_" &  To_String(CM);
         GFCont_File:=Dir & "contours/gfcont_file_" &  To_String(CM);
         Image_EFeed_File:=Dir & "points/image_efeed_point_" &  To_String(CM);

         Incr:=Cont'Length/Num_Of_Machines;
         I1:=Cont'First;
         I2:=I1+Incr-1;
         for I in 2..This_Machine loop
            I1:=I1+Incr;
            I2:=I1+Incr-1;
         end loop;
         if This_Machine=Num_Of_Machines then
            I2:=Cont'Last;
         end if;
         New_Line;
         Put("This machine works with the following range in the contour arrays: [");ShortPut(I1);Put(",");ShortPut(I2);Put("]");


         --READING TAYLOR
         New_Line;
         Put("Reading the renormalized fixed point ...");
         Put(To_String(RenTay_File));
         ShowErr:=False;
         Open(F,In_File,To_String(RenTay_File));
         Get(Rho,F,RenTay,IsPoly,GetPoly,Brackets,Decimal,ShowErr);
         Close(F);
         ShowErr:=True;
         Put(" done");

         New_Line;
         Put("Reading the perturbed fixed point ...");
         ShowErr:=False;
         Open(F,In_File,To_String(Tay_File_P));
         Get(Rho,F,Tay_P,IsPoly,GetPoly,Brackets,Decimal,ShowErr);
         Close(F);
         ShowErr:=True;
         Put(" done");
         New_Line;

         New_Line;
         Put("The perturbed fixed point:");
         New_Line;
         Show(Tay_P);
         New_Line;

         --READING AND COMPUTING POINTS
         Put("Reading points ...");
         ShowErr:=False;
         Open(F,In_File,P_File);
         Get(F,P,Brackets,Decimal,ShowErr);
         Close(F);
         Open(F,In_File,Cr_File);
         Get(F,CrPointt,Brackets,Decimal,ShowErr);
         Close(F);
         Open(F,In_File,ECrit_File);
         Get(F,ECr,Brackets,Decimal,ShowErr);
         Close(F);
         Open(F,In_File,Crit_File);
         Get(F,Cr,Brackets,Decimal,ShowErr);
         Close(F);
         Open(F,In_File,Centre_File);
         Get(F,Centre,Brackets,Decimal,ShowErr);
         Close(F);

         Open(F,In_File,ECentre_File);
         Get(F,ECentre,Brackets,Decimal,ShowErr);
         Close(F);
         Open(F,In_File,EFeed_File);
         Get(F,EFeed,Brackets,Decimal,ShowErr);
         Close(F);
         Open(F,In_File,Cn_File);
         Get(F,Cn,Brackets,Decimal,ShowErr);
         Close(F);
         Open(F,In_File,Cn2_File);
         Get(F,Cn2,Brackets,Decimal,ShowErr);
         Close(F);
         Open(F,In_File,Cn2n_File);
         Get(F,Cn2n,Brackets,Decimal,ShowErr);
         Close(F);
         Open(F,In_File,SolZeroVal_File);
         Get(F,Val_At_Zero,Brackets,Decimal,ShowErr);
         Close(F);
         LogB:=Neg(IBall)*Log(CoOne-P/Cn2);--image of C_{n+2} under inverse tau
         LogA:=AbsVal( Log(  (Cn2n-P)*Cn2/((Cn2-P)*Cn2n)  )  );
         LogBB:=LogB;
         Put(" done");


         --COMPUTING SOME EXTRA POINTS

         New_Line;
         Put("Computing new critical point and related points...");
         Newton(Qnplus1,Rho,Cr,Tay_P,CrPointt,IsPoly);
         TCr:=TauInv(Cr);
         FCAppr:=Half*(Cn+P);
         SInvH1(Qn,FCAppr,ECr,TCr,Tay_P,NumErr);
         ECr:=Exp((-Two)*ScalPi*IBall*ECr);
         ShowErr:=False;
         Create(F,Out_File,Crit_File);
         Put(F,Cr,Brackets,Decimal,ShowErr);
         Close(F);
         Create(F,Out_File,ECrit_File);
         Put(F,ECr,Brackets,Decimal,ShowErr);
         Close(F);
         ShowErr:=False;
         GetRow(Num_Of_Machines,ThickRad,Sol_File,ECr,V,Brackets,Decimal,ShowErr);
         GCr:=G_Value(Pex,R,AEP,ConstC,V,Val_At_Zero,ECr);
         Put("done");
         New_Line;


         New_Line;
         Put("Computing c_{q_n_2}...");
         Feed:=Cn2n;
         TFeed:=TauInv(Feed);
         FCAppr:=Feed;
         SInvH1(Qn,FCAppr,EFeed,TFeed,Tay_P,NumErr,True);
         FeedFCAppr:=FCAppr;
         Create(F,Out_File,EFeed_File);
         Put(F,EFeed,Brackets,Decimal,ShowErr);
         Close(F);
         Put("done");
         New_Line;


         New_Line;
         Put("Computing centre and related points...");
         Parametrize_1(Rad,C1,C2,RD);
         Newton(Qnplus2,Rho,Centre,Tay_P,C1,IsPoly);
         TCentre:=TauInv(Centre);
         ECentre:=ExpInv(ECentre);
         FCAppr:=P;
         SInvH1(Qn,FCAppr,ECentre,TCentre,Tay_P,NumErr);
         ECentre:=Exp((-Two)*ScalPi*IBall*ECentre);
         Create(F,Out_File,Centre_File);
         Put(F,Centre,Brackets,Decimal,ShowErr);
         Close(F);
         Create(F,Out_File,ECentre_File);
         Put(F,ECentre,Brackets,Decimal,ShowErr);
         Close(F);
         ShowErr:=False;
         GetRow(Num_Of_Machines,ThickRad,Sol_File,ECentre,V,Brackets,Decimal,ShowErr);
         GCentre:=G_Value(Pex,R,AEP,ConstC,V,Val_At_Zero,ECentre);
         Put("done");

         --DISPLAYING SOME INFO
         New_Line;
         Put("q_n=");ShortPut(Qn);
         New_Line;
         Put("c_r=");Show(Cr);
         New_Line;
         Put("p=");Show(P);
         New_Line;
         Put("c_q_(n+2)=");Show(Cn2);
         New_Line;
         Put("c_(q_(n+2)+q_n)=");Show(Cn2n);
         New_Line;
         Put("Tau^(-1)(c_r)=");Show(TCr);
         New_Line;
         Put("Tau^(-1)(c_q_(n+2))=");Show(TauInv(Cn2));
         New_Line;
         Put("Tau^(-1)(c_q_(n+2)+n)=");Show(TauInv(Cn2n));
         New_Line;
         Put("g_1^(-1) o Tau^(-1)(c_r)=");Show(ECr);
         New_Line;
         Put("Accuracy in g_1^(-1) o Tau^(-1)(c_r)=");Show(SH1(Qn,Centre,RePart(ExpInv(ECr)),ImPart(ExpInv(ECr)),Tay_P,IsPoly)-TCr);

         New_Line;
         Put("g o  g_1^(-1) o Tau^(-1)(c_r)=");Show(GCr);
         New_Line;
         Put("center=");Show(Centre);
         New_Line;
         Put("center of the contour=");Show(Complecs(X0,Y0));
         New_Line;
         Put("Tau^(-1)(center)=");Show(TCentre);
         New_Line;
         Put("g_1^(-1) o Tau^(-1)(center)=");Show(ECentre);
         New_Line;
         Put("g o g_1^(-1) o Tau^(-1)(center)=");Show(GCentre);
         New_Line;
         Put("Normalized g o g_1^(-1) o Tau^(-1)(center)=");Show(GCentre/GCr);
         New_Line;
         Put("Accuracy in g_1^(-1) o Tau^(-1)(center)=");Show(SH1(Qn,Centre,RePart(ExpInv(ECentre)),ImPart(ExpInv(ECentre)),Tay_P,IsPoly)-TCentre);
         New_Line;
         Put("g(0)=");Show(Val_At_Zero);
         New_Line;
         Put("|g_1^(-1) o Tau^(-1)(center)|=");Show(AbsVal(ECentre));

         if not Compute then
            goto SKIP;
         end if;

         --CONSTRUCTING CONTOURS, works only if Im(ECentre)<0, which is true almost always
         New_Line;
         Put("Computing contours...");
         ShowErr:=False;
         SupAr:=Sup(Arg(ECentre-Complecs(X0,Y0)));
         Psii:=Scal(SupAr+Rep(I1-Cont'First)*Del,SupAr+Rep(I1-Cont'First+1)*Del);
         if Inf(Psii)>Pi then
            Psii:=Psii-Two*ScalPi;
         end if;

         Create(F0,Out_File,TCont_File);
         Create(F7,Out_File,TFCont_File);
         Create(F1,Out_File,Cont_File);
         Create(F11,Out_File,Cont_File_1);
         Create(F12,Out_File,Cont_File_2);
         Create(F2,Out_File,FCont_File);
         Create(F3,Out_File,ECont_File);
         Create(F4,Out_File,EFCont_File);
         Create(F5,Out_File,GCont_File);
         Create(F6,Out_File,GFCont_File);
         FCAppr:=Half*(Cn+P);
         C22:=Complecs(0.9,-0.1);
         Open(F,In_File,Image_EFeed_File);
         Get(F,C22,Brackets,Decimal,ShowErr);
         Close(F);
         C1:=CoZero;
         Switch:=0;
         New_Line;
         Rad:=AbsVal(ECentre-Complecs(X0,Y0));
         for L in I1..I2 loop
            C:=SetBall(Scal(X0)+Rad*Cos(Psii),Scal(Y0)+Rad*Sin(Psii));
            C1:=ExpInv(C);
            C1:=SH1(Qn,CAppr,RePart(C1),ImPart(C1),Tay_P,IsPoly);
            Cont(L):= Tau(C1);  --contour in the fundumental crescent
            Put(F0,C1,Brackets,Decimal,False);
            New_Line(F0);
            Put(F1,Cont(L),Brackets,Decimal,False);
            New_Line(F1);
            GetRow(Num_Of_Machines,ThickRad,Sol_File,C,V,Brackets,Decimal,ShowErr);
            GCont(L):=G_Value(Pex,R,AEP,ConstC,V,Val_At_Zero,AbsVal(C),Arg(C));  --action of the solution of the BE on the contour in the exponentiated coordinates

            Put(F5,GCont(L),Brackets,Decimal,False);
            New_Line(F5);
            if (Sup(Psii)<=Zero or Inf(Psii)>=SupAr) then
               FCont(L):=Val(Qnplus2,Rho,Cont(L),Tay_P);  --contour of values in the fundumental crescent
            else
               FCont(L):=Val(Qnplus1,Rho,Cont(L),Tay_P);  --contour of values in the fundumental crescent
            end if;
            Put(F2,FCont(L),Brackets,Decimal,False);
            New_Line(F2);
            C1:=TauInv(FCont(L));
            Put(F7,C1,Brackets,Decimal,False);
            New_Line(F7);

            SInvH1(Qn,FCAppr,C22,C1,Tay_P,NumErr);
            C2:=Exp((-Two)*ScalPi*IBall*C22);
            Diff:=Sup(AbsVal(SH1(Qn,FCAppr,RePart(C22),ImPart(C22),Tay_P,IsPoly)-C1));
            if Diff>Rep(1.0E-7) then
               Put("Accuracy in InvH1:=");Txt_Put(Current_Output,Diff);
            end if;

            Put(F3,C,Brackets,Decimal,False);
            New_Line(F3);
            Put(F4,C2,Brackets,Decimal,False);
            New_Line(F4);

            ShowErr:=False;
            GetRow(Num_Of_Machines,ThickRad,Sol_File,C2,VV,Brackets,Decimal,ShowErr);
            GFCont(L):=G_Value(Pex,R,AEP,ConstC,VV,Val_At_Zero,AbsVal(C2),Arg(C2));--action of the solution of the BE on the contour of values in the exponentiated coordinates
            Put(F6,GFCont(L),Brackets,Decimal,False);
            New_Line(F6);

            Psii:=Psii+Scal(Del);
            if (Inf(Psii)>Pi and (Sup(Psii)-Del)<Pi)  then
               Psii:=(-ScalPi)+(Psii-ScalPi);
            end if;
         end loop;
         Close(F0);
         Close(F1);
         Close(F11);
         Close(F12);
         Close(F2);
         Close(F3);
         Close(F4);
         Close(F5);
         Close(F6);
         Close(F7);
         Put("done");

         if This_Machine>1 then
            return;
         end if;
         delay 850.0;

         <<SKIP>> L:=Cont'First;
         L:=Cont'First;
         I1:=Cont'First;
         I2:=I1+Incr-1;
         MinGCont:=Rep(10E+10);
         MaxGCont:=Zero;
         ShowErr:=False;
         for I in 1..Num_Of_Machines loop
            if I=Num_Of_Machines then
               I2:=Cont'Last;
            end if;
            Int1:=Integer'Image(I)'Length;
            Int2:=Integer'Image(Num_Of_Machines)'Length-1;
            CM:=To_Unbounded_String(Integer'Image(I)(2..Integer'Image(I)'Last));
            for J in Int1..Int2 loop
               CM:=To_Unbounded_String("0") & CM;
            end loop;
            Open(F0,In_File,GCont_File_F & To_String(CM));
            Open(F1,In_File,GFCont_File_F & To_String(CM));
            for JJ in I1..I2 loop
               Get(F0,C1,Brackets,Decimal,ShowErr);
               Get(F1,C2,Brackets,Decimal,ShowErr);
               GCont(L):=C1;
               GFCont(L):=C2;
               if Approx(AbsVal(C1))<MinGCont then
                  MinGCont:=Approx(AbsVal(GCont(L)));
               end if;
               if Approx(AbsVal(C1))>MaxGCont then
                  MaxGCont:=Approx(AbsVal(GCont(L)));
               end if;
               L:=L+1;
            end loop;
            Close(F1);
            Close(F0);
            I1:=I1+Incr;
            I2:=I1+Incr-1;
         end loop;


         New_Line;
         Put("Maximum radius of the contour before scaling=");Txt_Put(Current_Output,MaxGCont);
         New_Line;
         Put("Minimum radius of the contour before scaling=");Txt_Put(Current_Output,MinGCont);




         --COMPUTING TAYLOR COEFFICIENTS
         New_Line;
         Put("Computing the coefficients in the series...");
         SetZero(RenTay_P);
         for I in 0..17 loop
            Summa:=CoZero;
            for J in GCont'Range loop
               if J=GCont'First then
                  J1:=J;J2:=GCont'Last;
               else
                  J1:=J;J2:=J-1;
               end if;
               C3:=CoOne;
               C4:=CoOne;
               C5:=CoOne;
               for II in 1..I loop
                  C3:=C3/GCont(J1);
                  C4:=Two*C4/(GCont(J2)+GCont(J1));
                  C5:=C5/GCont(J2);
               end loop;
               if I/=0 then
                  Summa:=Summa-(GFCont(J1)/Rep(I))*(C3-C4)-(GFCont(J2)/Rep(I))*(C4-C5);
               else
                  Summa:=Summa+GFCont(J1)*(Log(Half*(GCont(J2)+GCont(J1)))-Log(GCont(J1)))+GFCont(J2)*(Log(GCont(J2))-Log(Half*(GCont(J2)+GCont(J1))));
               end if;
            end loop;
            SetComponent(I,Inv(TwoPiI)*Summa,RenTay_P);
         end loop;

         Put(" done");
         SetComponent(0,CoZero,RenTay_P);
         SetComponent(1,ExpTheta,RenTay_P);
         Der(Rho,Rep(0.95)*Rho,RenTay_P,DerRenTay_P,IsPoly);
         Newton(1,Rho,GCr,DerRenTay_P,CoZero,IsPoly);
         New_Line;
         Put("Critical point before scaling=");Show(GCr);
         New_Line;
         Put("Renormalized function before scaling:");
         Show(RenTay_P);


         MaxGCont:=MaxGCont/InfMod(GCr);
         MinGCont:=MinGCont/SupMod(GCr);
         New_Line;
         Put("Maximum radius of the contour after scaling=");Txt_Put(Current_Output,MaxGCont);
         New_Line;
         Put("Minimum radius of the contour after scaling=");Txt_Put(Current_Output,MinGCont);

         for I in 2..Pdeg loop
            SetComponent(I,(GCr**(I-1))*Component(I,RenTay_P),RenTay_P);
         end loop;

         Der(Rho,Rep(0.95)*Rho,RenTay_P,DerRenTay_P,IsPoly);
         GCr:=CoOne;
         Newton(1,Rho,GCr,DerRenTay_P,CoZero,IsPoly);
         New_Line;
         Put("Critical point of renormalization=");Show(GCr);
         Copy(RenTay_P,Tmp);
         AddComponent(1,Neg(CoOne),Tmp);
         PP:=P;
         Newton(1,Rho,PP,Tmp,CoZero,IsPoly);
         New_Line;
         Put("Repelling fixed point of renormalization=");Show(PP);
         New_Line;
         Put("Renormalized function:");
         Show(RenTay_P);

         New_Line;
         Put("||f||_");Txt_Put(Current_Output,Rho);Put("=");Txt_Put(Current_Output,Norm(Rho,Tay));
         New_Line;
         Put("||h||_");Txt_Put(Current_Output,Rho);Put("=");Txt_Put(Current_Output,Norm(Rho,Tay-Tay_P));
         New_Line;
         Put("||R(f)-R(f+h)||_");Txt_Put(Current_Output,Rho);Put("=");Txt_Put(Current_Output,Norm(Rho,RenTay-RenTay_P));
         New_Line;
         Put("||(eps)^{-1}*R(f+eps*h)-R(f)||_");Txt_Put(Current_Output,Rho);Put("=");Txt_Put(Current_Output,Norm(Rho,Complecs(One/(Eps*Delt),Zero)*(RenTay_P-RenTay)));
         Create(F,Out_File,To_String(RenTay_File_P));
         Put(F,RenTay_P,True,False,True,False);
         Close(F);
      end;
   end;
end Matrix_Column;



























