package body Numerics.Ops is

   Zero_Numeric: constant Numeric := Numeric(0.0);

   function MinusPi_Pi(S: Numeric) return Numeric is
 --     Numeric_2Pi: constant Numeric:=Two*Rep(3.14159_26535_89793_23);
 --     Numeric_Pi: constant Numeric:=Rep(3.14159_26535_89793_23);
 --     SS: Numeric:=S;
   begin
  --    while SS>=Numeric_2Pi loop
  --       SS:=SS-Numeric_2Pi;
  --    end loop;
  --    while SS<=Zero loop
  --       SS:=SS+Numeric_2Pi;
  --    end loop;
  --    if SS>Numeric_Pi then
  --       SS:=SS-Numeric_2Pi;
  --    end if;
      return S;
   end MinusPi_Pi;



   function Contains(R1,R2: Numeric) return Boolean is
   begin
      return  Approx(R1)=Approx(R2);
   end Contains;

   function Scal(R1,R2: Rep) return Numeric is
      Sum: constant Rep := R1+R2;
   begin
      return Numeric(Half*Sum);
   end Scal;

   function Ball(S: Numeric) return Numeric is
   begin
      return Zero_Numeric;
   end Ball;

   function SupAbs(S: Numeric) return Rep is
   begin
      return Abs(Rep(S));
   end SupAbs;

   function IntFloor(S: Numeric) return Integer is
   begin
      return Integer(Numeric'Floor(S));
   end IntFloor;

   function IntCeiling(S: Numeric) return Integer is
   begin
      return Integer(Numeric'Ceiling(S));
   end IntCeiling;

   function Cap(R: Radius; S: Numeric) return Numeric is
   begin
      if Abs(S) <= Numeric(R) then
         return S;
      else
         return Zero_Numeric;
      end if;
   end Cap;

   function Up(R: Rep; Dummy: Numeric) return Rep is
   begin
      return R+Rep'Safe_Small;
   end Up;

   procedure ErrMult(R: in Rep; S: in out Numeric) is
   begin
      null;
   end ErrMult;

   function "*"(R: Rep; S: Numeric) return Numeric is
   begin
      return Scal(R)*S;
   end "*";

   function "*"(S: Numeric; R: Rep) return Numeric is
   begin
      return Scal(R)*S;
   end "*";

   function "/"(S: Numeric; R: Rep) return Numeric is
   begin
      return S/Scal(R);
   end "/";

   function "/"(R: Rep; S: Numeric) return Numeric is
   begin
      return Scal(R)/S;
   end "/";

   function Sqr(S: Numeric) return Numeric is
   begin
      return S*S;
   end Sqr;

   function Inv(S: Numeric) return Numeric is
   begin
      return Scal(1.0)/S;
   end Inv;

   function Short_Exp(R: Numeric; Iter: Integer) return Numeric is
      Y: Numeric;
   begin
      if R=Scal(Zero) then return Scal(One);
      end if;
      Y := Scal(Zero);
      for I in reverse 1 .. Iter loop
         Y := Scal(One)+(abs(R)*Y)/Scal(Rep(I));
      end loop;
      if R<Scal(Zero) then
         Y:=Scal(One)/Y;
      end if;
      return Y;
   end Short_Exp;


   procedure CosSin(S: in Numeric; Sc,Ss: out Numeric) is
      Iter: constant Integer := 32;
      Co: Numeric;
   begin
      if S = Scal(Zero) then
         Sc := Scal(One);
         Ss := S;
      else
         declare
            K: Integer;
            R: Rep;
            X,T: Numeric;
         begin
            K := 0;
            R := SupAbs(S);
            while R>Half loop
               K := K+1;
               R := R*Half;
           end loop;
           X := (Half**K)*S;
           T := Sqr(X);
           Sc := Scal(One);
           Ss := Sc;
           if ((Iter-1) mod 2)=0 then
              Co:=Scal(One);
           else
              Co:=-Scal(One);
           end if;
           for I in reverse 1 .. Iter loop
              Sc := Co+Sc*T/Rep((2*I)*(2*I-1));
              Ss := Co+Ss*T/Rep((2*I)*(2*I+1));
              Co:=-Co;
           end loop;

           Ss := X*Ss;
           for I in 1 .. K loop
              T := Sc;
              Sc := Scal(One)-Two*Sqr(Ss);
              Ss := Two*(T*Ss);
           end loop;
         end;
      end if;
  end CosSin;


  function Sin(S: Numeric) return Numeric is
     Sc,Ss: Numeric;
  begin
     CosSin(S,Sc,Ss);
     return Ss;
  end Sin;

  function Cos(S: Numeric) return Numeric is
     Sc,Ss: Numeric;
  begin
     CosSin(S,Sc,Ss);
     return Sc;
  end Cos;


end Numerics.Ops;
