with System.Machine_Code;
use System.Machine_Code;

pragma Elaborate_All (System.Machine_Code);

procedure Round_Up is

  type Uns16 is mod 2**16;

  CW: constant Uns16 := 2#0000_1011_0110_0000#;
--                             abcd   ef ghij
--   ab=10  round up
--   cd=11  64 bit precision
--   e=1    allow rounding (mask exception)
--   f=0    disallow underflows
--   g=0    overflows not masked     (exception instead of NaN)
--   h=0    division by 0 not masked (exception instead of infinity)
--   i=0    disallow denormalized numbers
--   j=0    invalid operations not masked

--   bits 6,7,12,13,14,15 irrelevant

begin

  Asm("fldcw %0",Inputs => Uns16'Asm_Input("m",CW), Volatile => True);

end Round_Up;
