
package body Taylors.IO is

   pragma Suppress(Storage_Check);

   package Txt_Int_IO is new Ada.Text_IO.Integer_IO(Integer);
   use Txt_Int_IO;

   procedure Show(P: in Taylor; Cut: in Rep := Zero) is
      C: Comp;
      C1: Rep;
   begin
      for K in 0 .. Deg(P) loop
         C := Component(K,P);
         if SupMod(C)>Cut then
            New_Line;
            Put(Current_Output,"z^");
            Put(Current_Output,K,2,10);
            Put(Current_Output,"   ");
            Show(C);
         end if;
      end loop;
      C1 := ErrComp(P);
      if C1>Cut then
         New_Line;
         Put(Current_Output," E   ");
         Txt_Put(Current_Output,C1);
      end if;
      New_Line;
   end Show;

   procedure Get(R: in Radius; F: in File_Type; P: out Taylor; IsPoly: in out Boolean; GetPoly: in Boolean;  Brackets: in Boolean:=False;Decimal: in Boolean := True; ShowErr: in Boolean:=True) is
      D: Integer;
      E: Comp := CompZero;
      C: Rep;
      C1: Comp;
      B: Rep:= R;
   begin
      SetZero(P);
      Get(File=>F, Item=>D);
      P.D:=Size;
      if D<Size then
         P.D:=D;
      end if;
      if D<0 then return; end if;
      C:=Rep(0.0);
      if not GetPoly then
         SetErrComp(C,P);
      else
         C:=Zero;
         SetErrComp(C,P);
      end if;
      IsPoly := (IsPoly and C=Zero);
      for K in 0 .. D loop
         Get(F,C1,Brackets,Decimal,ShowErr);
         if K <= Size then
            SetComponent(K,C1,P);
         else
            E := E+B*Ball0(SupMod(C1));
            B := R*B;
         end if;
      end loop;
      SetComponent(Size,Component(Size,P)+E,P);  -- add higher order error
      IsPoly := (IsPoly and E=CompZero);
   end Get;

   procedure Put(F: in File_Type; P: in Taylor; PutPoly: in Boolean; Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in Boolean:=True) is
      Pt: Taylor;
   begin
      Copy(P,Pt);
      Cleanup(Pt);
      Put(File=>F, Item=>Deg(Pt), Width=>3);
      New_Line(F);
      if Deg(Pt)<0 then return; end if;
      if not PutPoly then
         Txt_Put(F,ErrComp(Pt),Decimal);
         New_Line(F);
      end if;
      for K in 0 .. Deg(Pt) loop
         Put(F,Component(K,Pt),Brackets,Decimal,ShowErr);
         New_Line(F);
      end loop;
   end Put;

end Taylors.IO;
