with Ada.Text_IO;
use Ada.Text_IO;

pragma Elaborate_All(Ada.Text_IO);

generic

   with procedure Txt_Get(F: in File_Type; R: out Rep; Decimal: in Boolean := True) is <>;
   with procedure Txt_Put(F: in File_Type; R: in Rep; Decimal: in Boolean := True) is <>;

   with procedure Show(S: in Comp; Cut: in Rep:=Zero) is <>;
   with procedure Get(F: in File_Type; S: out Comp;  Brackets: in Boolean:=False;Decimal: in Boolean := True;ShowErr: in Boolean:=True) is <>;
   with procedure Put(F: in File_Type; S: in Comp; Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in Boolean:=True) is <>;

package Taylors.IO is

   procedure Show(P: in Taylor; Cut: in Rep := Zero);
   procedure Get(R: in Radius; F: in File_Type; P: out Taylor; IsPoly: in out Boolean;
                GetPoly: in Boolean;  Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in Boolean:=True);
   procedure Put(F: in File_Type; P: in Taylor;
                 PutPoly: in Boolean;  Brackets: in Boolean:=False; Decimal: in Boolean := True; ShowErr: in Boolean:=True);

end Taylors.IO;
