with Reps,Reps.Ops,Reps.IO, Intervals,Intervals.Ops,Intervals.IO;
use Reps,Reps.Ops, Reps.IO,Intervals,Intervals.Ops, Intervals.IO;
with Ada.Text_IO,Ada.Float_Text_IO;
use Ada.Text_IO,Ada.Float_Text_IO;
with Ada.Text_IO,Ada.Integer_Text_IO;
use Ada.Text_IO,Ada.Integer_Text_IO;
generic

with function "**"(S: Rep;I: Integer) return Rep is <>;

package Taylors.Ops is

   procedure AddComponent(D: in Power; S: in Comp; P: in out Taylor); -- P[D] := P[D] + S
   procedure MultComponent(D: in Power; S: in Comp; P: in out Taylor);-- P[D] := P[D] + S
   procedure AddErrComp(S: in Comp; P: in out Taylor);                -- add |S| to general error
   procedure AddErrComp(S: in Rep; P: in out Taylor);                 -- add |S| to general error
   procedure MultErrComp(S: in Comp; P: in out Taylor);               -- multiply general error by |S|
   procedure MultErrComp(S: in Rep; P: in out Taylor);                -- multiply general error by |S|
   function Coeff(R: Radius; K: Power; P: Taylor) return Comp;        -- P_K
   procedure ResetCenter(P: in out Taylor; Kmin: in Natural := 0;
                         Kmax: in Integer := Size);                   -- Reset centers of P.C(Kmin .. Kmax)
   function Val(N: Integer; R: Radius; Z: Comp; P: Taylor) return Comp;           -- P(Z)
   function Norm(R: Radius; P: Taylor) return Rep;                    -- Norm ||P||_R
   procedure Neg(P1: in Taylor; P2: out Taylor);                      -- P2 := -P1
   function "-"(P: Taylor) return Taylor;                             -- -P
   procedure Mult(S: in Comp; P: in out Taylor);                      -- P := S*P
   procedure Prod(S: in Comp; P1: in Taylor; P2: out Taylor);         -- P2 := S*P1
   function "*"(S: Comp; P: Taylor) return Taylor;                    -- S*P
   procedure Add(P1: in Taylor; P2: in out Taylor);                   -- P2 := P2+P1
   procedure Sum(P1,P2: in Taylor; P3: out Taylor);                   -- P3 := P1+P2
   function "+"(P1,P2: Taylor) return Taylor;                         -- P1+P2
   procedure Sub(P1: in Taylor; P2: in out Taylor);                   -- P2 := P2-P1
   procedure Diff(P1,P2: in Taylor; P3: out Taylor);                  -- P3 := P1-P2
   function "-"(P1,P2: Taylor) return Taylor;                         -- P1-P2
   procedure MultAdd(S: in Comp; P1: in Taylor; P2: in out Taylor);   -- P2 := P2+S*P1
   procedure DegConvert(R: in Radius; D: in Degree; P: in out Taylor);-- Enlarge P by reducing Deg
   procedure Mult(R: in Radius; P1: in Taylor; P2: in out Taylor;
                  D: in Degree := Size);                              -- P2 := P2*P1
   procedure Prod(R: in Radius; P1,P2: in Taylor; P3: out Taylor;
                  D: in Degree := Size);                              -- P3 := P1*P2
   function Prod(R: Radius; P1,P2: Taylor;
                            D: Degree := Size) return Taylor;         -- P1*P2
   procedure Compose(P1,P2: in Taylor; P3: out Taylor);
   function Compose(P1,P2: Taylor) return Taylor;
   function DerVal(N: Integer; R1,R2: Radius;
                               Z: Comp; P: Taylor) return Comp;       -- P'(Z)
   function DerDerVal(N: Integer; R1,R2: Radius;
                                  Z: Comp; P: Taylor) return Comp;    -- P''(Z)
   procedure Fmax1(R: in Rep; M: out Natural; F: out Rep);
   procedure Der(R1,R2: in Radius;
                 P1: in Taylor;
                 P2: out Taylor; IsPoly: in Boolean := False);        --P2=P1'
   function Der(R1,R2: Radius;
                P: Taylor;
                IsPoly: in Boolean := False) return Taylor;           --returns P'
   procedure Newton(N: in Integer; Rho: in Radius;
                                   P: in out Comp;
                                   Tay: in Taylor;
                                   E: in Comp;
                                   IsPoly: in Boolean:=False);         --Finds P, s.t. Tay[P]=E

   pragma Inline (AddComponent,MultComponent,AddErrComp,MultErrComp,Coeff);

end Taylors.Ops;
